#!/usr/bin/env bash
#
# Deploy the SImA container stack
# To be run inside the SImA installation directory
#
### Copyright ©2021 PerkinElmer, Inc. All Rights Reserved. ###

stack=SImA

if [[ $# > 1 || "$1" == "-h" || "$1" == "--help" ]]; then
  cat <<.
Deploy the SImA container stack

Usage: $0 [stack]

stack: name of the container stack, default: $stack
.
  exit 1
fi

[[ "$1" != "" ]] && stack="$1"

docker stack deploy -c docker-compose.yml "$stack"

#.
