#!/usr/bin/env bash
#
# Undeploy the SImA container stack
#
### Copyright ©2021 PerkinElmer, Inc. All Rights Reserved. ###

stack=SImA

if [[ $# > 1 || "$1" == "-h" || "$1" == "--help" ]]; then
  cat <<.
Take down the SImA container stack and wait until all containers have stopped.

Usage: $0 [stack]

stack: name of the container stack, default: $stack
.
  exit 1
fi

[[ "$1" != "" ]] && stack="$1"

function wait_until_container_count()
{
  max=$1
  while [[ $(docker ps -q -f "NAME=${stack}_" | wc -l) > $max ]]; do
    sleep 2
  done
}


### Action ###

echo "Removing all $stack services except ${stack}_loki"
names=$(docker service ls -f "NAME=${stack}_" --format "{{.Name}}" | grep -v loki)
docker service rm $names >& /dev/null ||:

echo Waiting for containers to stop ...
wait_until_container_count 1

echo "Removing service ${stack}_loki"
docker service rm "${stack}_loki" >& /dev/null ||:
wait_until_container_count 0

# Take down the rest of the stack
docker stack rm "$stack" ||:

# .